﻿using System;
using System.ComponentModel;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace NUnitTestRunnerWP7.ViewModels
{
	public class UnitTestResultViewModel : INotifyPropertyChanged
	{
		public UnitTestResultViewModel()
		{
			if (DesignerProperties.IsInDesignTool)
			{
				// Loading some sample data for Blendability
				this.ClassName = "SampleClass";
				this.ElapsedMilliseconds = 1000;
				this.ErrorMessage = "Sample Error Message";
				this.MethodName = "SampleMethod";
				this.Result = TestResult.Failed;
			}
		}

		public string FullPath
		{
			get
			{
				return string.Format("{0}.{1}",this.ClassName,this.MethodName);
			}
		}

		public string ResultColor
		{
			get
			{
				switch (result)
				{
					case TestResult.Failed:
						return "Red";
					case TestResult.Ignored:
						return "Orange";
					default:
						return "GreenYellow";
				}
			}
		}

		private TestResult result;
		public TestResult Result
		{
			get
			{
				return result;
			}
			set
			{
				if (result != value)
				{
					result = value;
					OnPropertyChanged("Result");
				}
			}
		}

		public string ResultIcon
		{
			get
			{
				switch (result)
				{
					case TestResult.Failed:
                        return "/NUnitTestRunnerWP7;component/Images/Failed.png";
					case TestResult.Ignored:
                        return "/NUnitTestRunnerWP7;component/Images/Ignored.png";
					default:
                        return "/NUnitTestRunnerWP7;component/Images/Passed.png";
				}
			}
		}
		
		public Visibility ErrorMessageVisibility
		{
			get
			{
				if (string.IsNullOrEmpty(this.ErrorMessage))
				{
					return Visibility.Collapsed;
				}
				else
				{
					return Visibility.Visible;
				}
			}
		}

		private string className = string.Empty;
		public string ClassName
		{
			get { return className; }
			set 
			{ 
				if (className != value)
				{
					className = value;
					OnPropertyChanged("ClassName");
				}
			}
		}

		private string methodName = string.Empty;
		public string MethodName
		{
			get { return methodName; }
			set
			{
				if (methodName != value)
				{
					methodName = value;
					OnPropertyChanged("MethodName");
				}
			}
		}

		private int elapsedMilliseconds;
		public int ElapsedMilliseconds
		{
			get
			{
				return elapsedMilliseconds;
			}
			set
			{
				if (elapsedMilliseconds != value)
				{
					elapsedMilliseconds = value;
					OnPropertyChanged("EllapsedMilliseconds");
				}
			}
		}

		private string errorMessage = string.Empty;
		public string ErrorMessage
		{
			get
			{
				return errorMessage;
			}
			set
			{
				if (errorMessage != value)
				{
					errorMessage = value;
					OnPropertyChanged("ErrorMessage");
				}
			}
		}



		#region INotifyPropertyChanged Members

		public event PropertyChangedEventHandler PropertyChanged;
		protected void OnPropertyChanged(string propertyName)
		{
			if (PropertyChanged != null)
				PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
		}

		#endregion
	}
}
